#include <math.h>
#include <stdio.h>

#include <binned.h>

#include "../common/common.h"

/**
 * @internal
 * @brief Print manually specified binned double precision
 *
 * @param fold the fold of the binned types
 * @param priX X's primary vector
 * @param incpriX stride within X's primary vector (use every incpriX'th element)
 * @param carX X's carry vector
 * @param inccarX stride within X's carry vector (use every inccarX'th element)
 *
 * @author Hong Diep Nguyen
 * @author Peter Ahrens
 * @date   27 Apr 2015
 */
void binned_dmprint(const int fold, const double *priX, const int incpriX, const double *carX, const int inccarX) {
  int i;
  double M;
  for (i = 0; i < fold; i++, priX += incpriX, carX += inccarX) {
    M = UFP(priX[0]);
    printf("(2^%d: %g #%g =%g)\n", (int)log2(M) + 1, priX[0] - 1.5*M, carX[0], ((carX[0] - 6) * 0.25 * M + priX[0]));
  }
}
